﻿var objIdArray = ["beginCard", "endCard", "beginRfPort", "endRfPort", "beginChannel", "endChannel"]
var udpObjIdArray = ["addUdpNumber", "destIpBegin", "destIpLineStep", "destIpChanStep", "udpPortBegin", "udpPortLineStep", "udpPortChanStep", "portSwitch",
					"networkPortGroup", "channelNo", "streamType", "backupEnable", "backupUdpPort", "inServiceId", "inServiceIdLineStep", 
                  "outServiceId", "outServiceIdLineStep", "pmv", "pmvLineStep", "dtsAdjust", "adjustBitrate", "switchBitrate", "bufferSize", "modeCheck", "mode", "sourceIp"];
var defaultValueArray = ["0", "0", "--", "--", "1","1"];
var defaultUdpValueArray = ["10", "0.0.0.0", "0", "0", "49156", "2", "256", "0",
						 "--", "0", "0", "0", "0", "0", "0", "2", "1", 
						 "2", "1", "0", "0", "0", "0", "0", "0", "0.0.0.0"];
var FIRST_DELIMITER = "|";
var SECOND_DELIMITER = ",";

var rfPortNumber = 0;
var maxGbeNumber = 0; 
var max10GbeNumber = 0;
var portString = ["Port", "端口"];
var language;
var batchType;
var maxChannelNumber = 96;

function PageLoadHandler()
{
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	getChannel();	
	
	document.body.style.cursor = "auto";
	window.status = "Done";
}

function pageRefresh()
{
	PageLoadHandler();
}

$(document).ready(function()
{
	var apply = document.getElementById("Apply");
	language = document.getElementById("language").value;
	applyDispay(parent.group, apply);
	PageLoadHandler();
	$(".pid_map_table td").dblclick(function()
	{
		var $tdObj = $(this);
		var inputControl = $("<input type='text' style='width: 52px;' />").val($tdObj.text());
		inputControl.blur(function()
		{
			var inputPidValue = $(this).val();
			if(pidCheck($(this)) == true)
			{
				$(this).remove();
				if(inputPidValue == "")
				{
					$tdObj.text("-");
				}
				else
				{
					$tdObj.text(inputPidValue);
				}			
			}
			else
			{
				$(this).remove();
				$tdObj.text("-");
				if(navigator.userAgent.indexOf("Firefox") > -1)
				{
					if(window.getSelection())
					{
						window.getSelection().removeAllRanges();
					}
				} //火狐浏览器bug,在onblur中使用alert，关闭提示框后会认为鼠标左键没有释放，移动鼠标，会选中页面文字			
			}			
		});
		$tdObj.text("");
		$tdObj.append(inputControl);
		setTimeout(function () {inputControl.focus()}, 50);
		inputControl.select();
	});
	$("#modeCheck").click(function()
	{
		if($(this).prop("checked"))
		{
			$(this).val(1);
			$("#mode").attr("disabled", false);
		}
		else
		{
			$(this).val(0);
			$("#mode").attr("disabled", true);
		}
	});
	$("#batchUdpCheckbox").click(function()
	{
		if($(this).prop("checked"))
		{
			$("#udpBatchTable tr.udp_set_param_tr").show();
		}
		else
		{
			$("#udpBatchTable tr.udp_set_param_tr").hide();
		}
	});
	$("#batchPidCheckbox").click(function()
	{
		if($(this).prop("checked"))
		{
			$("#pidBatchTable").show();
		}
		else
		{
			$("#pidBatchTable").hide();
		}
	});
});

function getChannel()
{
	var xmlhttp = false;
	var cnt = 0;
	xmlhttp = getHTTPObject();
	var params = "type=59&cmd=1&getAttrVal=0";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var response = xmlhttp.responseText;
			var deviceInfo = response.slice(7, -8).split("&");
			rfPortNumber = deviceInfo[0];
			maxGbeNumber = deviceInfo[1];
			max10GbeNumber = deviceInfo[2];
			displayRfPort();
			displayPortGroup();
			resetDefault();
		}
	}
	xmlhttp.send(params);
	return false;
}

function displayRfPort()
{
	var $beginRfPort = $("#beginRfPort");
	var $endRfPort = $("#endRfPort");
	$beginRfPort.empty();
	$endRfPort.empty();
	for(var i = 0; i < rfPortNumber; i++)
	{
		$beginRfPort.append("<option value=" + i + ">RF " + portString[language] + (i + 1) +  "</option>");
		$endRfPort.append("<option value=" + i + ">RF " + portString[language] + (i + 1) + "</option>");
	}
}

function displayPortGroup()
{
	var $networkPortGroup = $("#networkPortGroup");
	$networkPortGroup.empty();
	if(maxGbeNumber % 2 == 0)
	{
		gpairOptionLength = maxGbeNumber/2;
	}
	else
	{
		gpairOptionLength = maxGbeNumber/2 + 1;
	}
	if(max10GbeNumber % 2 == 0)
	{
		g10pairOptionLength = max10GbeNumber/2;
	}
	else
	{
		g10pairOptionLength = max10GbeNumber/2 + 1;
	}
	for(var j = 0; j < gpairOptionLength; j++)
	{
		option = $("<option>").text("GPair" + (j + 1)).val(j);
		$networkPortGroup.append(option);
	}
	for(var j = 0; j < g10pairOptionLength; j++)
	{
		option = $("<option>").text("10GPair" + (j + 1)).val(16 + j);
		$networkPortGroup.append(option);
	}
}

function batchAddApply()
{
	var channelMode = $("#channelMode").val();
	if($("#batchUdpCheckbox").prop("checked") && $("#batchPidCheckbox").prop("checked"))
	{
		batchType = 2;
	}
	else if($("#batchUdpCheckbox").prop("checked"))
	{
		batchType = 0;
	}
	else if($("#batchPidCheckbox").prop("checked"))
	{
		batchType = 1;
	}
	if(paramCheck() == false)
	{
		return;
	}
	var getParams = "type=59&cmd=2&batchType=" + batchType + "&batchSetString=";
	getParams = getParams + generateData();
	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("Batch set successfully!");
			}
			else
			{
				alert("批量设置成功!");
			}
			PageLoadHandler();
		}
	}
	xmlhttp.send(getParams);
	return true;
}
function generateData()
{
	var data;
	var pidData = "";
	for(var i = 0,len = objIdArray.length; i < len; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else
		{
			data += SECOND_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	for(var i = 0,len = udpObjIdArray.length; i < len; i++)
	{
		if(i == 0)
		{
			data += FIRST_DELIMITER + $("#" + udpObjIdArray[i]).val();
		}
		else
		{
			data += SECOND_DELIMITER + $("#" + udpObjIdArray[i]).val();
		}
	}
	if((batchType == 1) || (batchType == 2))
	{
		$(".pid_map_table").each(function(tableIndex ,tableEle)
		{
			$("td", $(this).find("tr:eq(0)")).each(function(tdIndex, ele)
			{
				if($(this).text() != "-")
				{
					var mapTdText = $(tableEle).find("tr:eq(1)").find("td:eq(" + tdIndex + ")").text();
					if(mapTdText != "-")
					{
						if(pidData == "")
						{
							pidData = $(this).text() + SECOND_DELIMITER + mapTdText;
						}
						else
						{
							pidData += SECOND_DELIMITER + $(this).text() + SECOND_DELIMITER + mapTdText;
						}					
					}
				}
			});
		});
	}	
	data += FIRST_DELIMITER + pidData;
	return data;
}

function resetDefault()
{
	for(var i = 0,len = objIdArray.length; i < len; i++)
	{
		if(defaultValueArray[i] != "--")
		{
			$("#" + objIdArray[i]).val(defaultValueArray[i]);
		}
		else
		{
			$("#" + objIdArray[i] + "option:first").prop("selected", true);
		}
	}
	for(var i = 0,len = udpObjIdArray.length; i < len; i++)
	{
		if(defaultUdpValueArray[i] != "--")
		{
			$("#" + udpObjIdArray[i]).val(defaultUdpValueArray[i]);
		}
		else
		{
			$("#" + udpObjIdArray[i] + "option:first").prop("selected", true);
		}
	}
	$("#modeCheck").prop("checked", false);
	$(".pid_map_table td").each(function()
	{
		$(this).text("-");
	});
}

function pidCheck(obj)
{
	var curPidData = obj.val();
	if((curPidData == "-") || (curPidData == ""))
	{
		return true;
	}
	if(validID(curPidData, language) == false)
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	var ch = curPidData.slice(0, 2);
	if((ch == "0x") || (ch == "0X"))  //十六进制
	{
		var numVal = parseInt(curPidData, 16);
	}
	else  //十进制
	{
		var numVal = parseInt(curPidData, 10);
	}
	if((numVal < 0) || (numVal > 8191))
	{
		if(language == 0)
		{
			alert("Valid range for pid is 0(0) - 8191(0x1fff).");
		}
		else
		{
			alert("PID的范围是0(0) - 8191(0x1fff)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}
function checkStartChannelNumber(data)
{
	if(validateNumber(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for start channel.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的起始频点值。");
		}
		return false;
	}
	if((data < 1) || (data > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for start channel is 1 - " + maxChannelNumber + ".");
		}
		else
		{
			alert("起始频点的范围是1 - " + maxChannelNumber + "。");
		}
		return false;
	}
	return true;
}

function checkEndChannelNumber(data)
{
	if(validateNumber(data) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for end channel.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的结束频点值。");
		}
		return false;
	}
	if((data < 1) || (data > maxChannelNumber))
	{
		if(language == 0)
		{
			alert("Valid range for end channel is 1 - " + maxChannelNumber + ".");
		}
		else
		{
			alert("结束频点的范围是1 - " + maxChannelNumber + "。");
		}
		return false;
	}
	return true;
}

function paramCheck()
{
	if((parseInt($("#beginCard").val(), 10) >  parseInt($("#endCard").val(), 10)) || (parseInt($("#beginRfPort").val(), 10) >  parseInt($("#endRfPort").val(), 10)) || (parseInt($("#beginChannel").val(), 10) >  parseInt($("#endChannel").val(), 10)))
	{
		if(language == 0)
		{
			alert("The start of batch range must be smaller than the end!");
		}
		else
		{
			alert("批量范围的起始值必须小于结束值！");
		}
		return false;
	}
	var obj;
	obj = $("#beginChannel");	
	if(!checkStartChannelNumber(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#endChannel");	
	if(!checkEndChannelNumber(obj.val()))
	{
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#addUdpNumber");
	var addUdpNumberValue = obj.val();
	if(validateNumber(addUdpNumberValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Add Port Number.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的添加个数。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((addUdpNumberValue < 1)|| (addUdpNumberValue > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Add Port Number is 1 - 65535.");
		}
		else
		{
			alert("添加端口个数的取值范围是1 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#destIpBegin");	
	if(Validate_IP_Format(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid IP Address. Please enter a valid Multicast IP Address.");
		}
		else
		{
			alert("无效的IP地址，请输入一个有效的组播IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#destIpLineStep");
	if(validateNumber(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for IP Address (UDP Port Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的IP地址(UDP端口间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#destIpChanStep");
	if(validateNumber(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for IP Address (Channel Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的IP地址(频点间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#udpPortBegin");
	var udpPortValue = obj.val();
	if(validateNumber(udpPortValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for UDP Port.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的UDP端口号。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((udpPortValue < 1)|| (udpPortValue > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Destination UDP Port is 1 - 65535.");
		}
		else
		{
			alert("目的UDP端口号的取值范围是1 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#udpPortLineStep");
	if(validateNumber(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for UDP Port (UDP Port Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的UDP端口(UDP端口间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#udpPortChanStep");
	if(validateNumber(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for UDP Port (Channel Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的UDP端口(频点间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#backupUdpPort");
	var backupPortValue = obj.val();
	if(validateNumber(backupPortValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Backup UDP Port.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的备份UDP端口号。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((backupPortValue < 0) || (backupPortValue > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Backup UDP Port is 0 - 65535.");
		}
		else
		{
			alert("备份UDP端口号的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#inServiceId");
	var inServiceidValue = obj.val();
	if(validateNumber(inServiceidValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Input Program Number.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的输入节目号。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((inServiceidValue < 0) || (inServiceidValue > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Input Program Number is 0 - 65535.");
		}
		else
		{
			alert("输入节目号的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#inServiceIdLineStep");
	var inServiceIdStepValue = obj.val();
	if(validateNumber(inServiceIdStepValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Input Program Number (UDP Port Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的输入节目号(UDP端口间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#outServiceId");
	var outServiceidValue = obj.val();
	if(validateNumber(outServiceidValue) == false )
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Output Program Number.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的输出节目号。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((outServiceidValue < 1) || (outServiceidValue > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Output Program Number is 1 - 65535.");
		}
		else
		{
			alert("输出节目号的范围是1 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#outServiceIdLineStep");
	var outServiceIdStepValue = obj.val();
	if(validateNumber(outServiceIdStepValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Output Program Number (UDP Port Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的输出节目号(UDP端口间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#pmv");
	var pmvValue = obj.val();
	if(validateNumber(pmvValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for PMV.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的PMV。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((pmvValue < 0) || (pmvValue > 510))
	{
		if(language == 0)
		{
			alert("Valid range for PMV is 0 - 510.");
		}
		else
		{
			alert("PMV的范围是0 - 510。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#pmvLineStep");
	var pmvIncValue = obj.val();
	if(validateNumber(pmvIncValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for PMV (UDP Port Increment).");
		}
		else
		{
			alert("无效的数字，请输入一个有效的PMV(UDP端口间增量)。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#adjustBitrate");
	var dtsAdjustBitrateValue = obj.val();
	if(validateNumber(dtsAdjustBitrateValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Data Rate.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的数据码率。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((dtsAdjustBitrateValue < 0) || (dtsAdjustBitrateValue > 200000))
	{
		if(language == 0)
		{
			alert("Valid range for Data Rate is 0 - 200000.");
		}
		else
		{
			alert("数据码率的范围是0 - 200000。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#switchBitrate");
	var switchBitrateValue = obj.val();
	if(validateNumber(switchBitrateValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Switch Rate.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的切换码率。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((switchBitrateValue < 0) || (switchBitrateValue > 200000))
	{
		if(language == 0)
		{
			alert("Valid range for Switch Rate is 0 - 200000.");
		}
		else
		{
			alert("切换码率的范围是0 - 200000。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#bufferSize");
	var bufferSizeValue = obj.val();
	if(validateNumber(bufferSizeValue) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for Buffer Size.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的缓存大小。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((bufferSizeValue < 0) || (bufferSizeValue > 200000))
	{
		if(language == 0)
		{
			alert("Valid range for Buffer Size is 0 - 200000.");
		}
		else
		{
			alert("缓存大小的范围是0 - 200000。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	obj = $("#sourceIp");
	if(Validate_IP_Format(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid IP Address. Please enter a valid Source IP address.");
		}
		else
		{
			alert("无效的IP地址，请输入一个有效的源IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	
	return true;
}